/* -*-C-*-
 ##############################################################################
 #
 # File:         machType.c
 # RCS:		"@(#)$Revision: 1.8 $ $Date: 93/06/29 17:59:02 $"
 # Description:  
 # Author:       Jeff Harrell
 # Created:      Mar 21,1991
 # Language:     C 
 # Package:      HP35635
 # Status:       "@(#)$State: Exp $"
 #
 # (C) Copyright 1993, Hewlett-Packard Company, all rights reserved.
 #
 ##############################################################################
*/


/* These are the expected sizes of the BINARY values in the SDF/TOOLKIT
** data formats. If the architecture of the system differs, compensation 
** will have to be made.
*/

#ifndef _TK_MACHTYPE_INCLUDED
#    define _TK_MACHTYPE_INCLUDED

/*   Defines for machine dependent data sizes */

/*   macros used in for bit swap operations  */
#    define BIN_UNSWAP               0
#    define BIN_SWAP                 1
#    define ASCII_UNSWAP             2
#    define ASCII_SWAP               3

#    define BYTE_SIZE_OF_SHORT	     2
#    define BYTE_SIZE_OF_LONG	     4
#    define BYTE_SIZE_OF_FLOAT       4
#    define BYTE_SIZE_OF_DOUBLE	     8
#    define BYTE_SIZE_OF_ENUM        4

#    define BYTE_SIZE_OF_DOS_INT     2
#    define BYTE_SIZE_OF_HPUX_INT    4




/*   Defines for processors/operating systems */

#    ifdef _MSDOS
#        define DOS_OS
#        define INTEL_PROC
#    endif

#    ifdef OS2
#        define OS2_OS
#        define INTEL_PROC
#    endif

#    ifdef VMS   
#        define VMS_OS
#        define DEC_PROC
#    endif

#    ifdef __hpux
#      define HPUX_OS
#      ifndef __hppa
#          define MOTOROLA_PROC
#      else
#          define HP_RISC
#      endif
#    endif

#    ifdef __hp9000s300
#       define HP9000S300
#    endif
#    ifdef __hp9000s700
#       define HP9000S700
#       define SICL
#    else
#       ifdef __hp9000s800
#          define HP9000S800
#       endif
#    endif

     /*
      * When building downloadables for use in the E1485 or HP3565 system,
      * the compiler thinks is generating code which runs on a s300 HP-UX
      * machine.  Therefore, the checks above may be invalid.  If we are
      * generating downloadable code, we need to back out any damage done
      * above.
      */
#    ifdef HP3565_SOURCE
#        undef HPUX_OS
#        undef HP9000S300
#    endif
#    ifdef E1485_SOURCE
#        undef HPUX_OS
#        undef HP9000S300
#    endif
#    ifdef SPOS_SOURCE
#        undef HPUX_OS
#        undef HP9000S300
#    endif

/* the definition of size of integers and floats have been
   chosen so that we can use the same definitions for both 
   MSDOS and HPUX
*/
 
# if (defined HPUX_OS) || (defined DOS_OS)         \
                       || (defined VMS_OS)         \
                       || (defined HP3565_SOURCE)  \
                       || (defined E1485_SOURCE)   \
                       || (defined SPOS_SOURCE)    \
                       || (defined __hp64000)

#   define SHORTSIZ16               short  /* 16 bits */
#   define USHORTSIZ16    unsigned  short  /* 16 bits */
#   define LONGSIZ32                long   /* 32 bits */
#   define ULONGSIZ32     unsigned  long   /* 32 bits */
#   define FLOATSIZ32               float  /* 32 bits */
#   define UNIQUE_PTR               long   /* 32 bits */
#   define FLOATSIZ64               double /* 64 bits */
#   define STREAM_PTR               FILE *
#   define CHAR_PTR                 char *
#   define CHAR_FAR_PTR             char far *

# endif 

/* DOS requires 'far' pointers in MIL */

#    ifdef DOS_OS
#        define DOS_FAR __far
#    else
#        define DOS_FAR 
#    endif
#endif  /* MACHTYPE_INCLUDED */
